﻿using System.Collections.Generic;
using System.Linq;

using HIPS.Web.Components.Common;

namespace HIPS.Web.UI.ViewModels.Shared
{

    /// <summary>
    /// Represents a list of textual messages to be displayed by a view.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
    /// </history>
    public class ViewMessageList : List<ViewMessage>
    {

        #region Methods

        /// <summary>
        /// Adds a new message to the list.
        /// </summary>
        /// <param name="description">Description text for the message.</param>
        /// <param name="level">Level associated with the message.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 December 2013">Initial version.</change>
        /// </history>
        public void Add(string description, MessageLevel level)
        {
            this.Add(new ViewMessage(description, level));
        }

        /// <summary>
        /// Determines if the list of messages contains any warning messages.
        /// </summary>
        /// <returns>Boolean. true if the list contains any warning messages, false otherwise.</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public bool ContainsWarning()
        {
            return this.Any(m => m.Level == MessageLevel.Warning);
        }

        /// <summary>
        /// Determines if the list of messages contains any error messages.
        /// </summary>
        /// <returns>Boolean. true if the list contains any error messages, false otherwise.</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public bool ContainsError()
        {
            return this.Any(m => m.Level == MessageLevel.Error);
        }

        #endregion

    }
}